package com.vmware.samples.chassisui {

import com.vmware.data.Constraint;
import com.vmware.data.PropertySpec;
import com.vmware.data.ResourceSpec;
import com.vmware.data.query.*;

import mx.resources.ResourceManager;

/**
 * Various utilities
 */
public class Util {
   // Resource bundle name,  matches the defaultBundle attribute in plugin.xml
   private static var BUNDLE_NAME:String = "com_vmware_samples_chassis";

   /**
    * Get a string resource from the default plugin bundle, or return null if not found.
    */
   public static function getString(key:String, parameters:Array = null) : String {
      return ResourceManager.getInstance().getString(BUNDLE_NAME, key, parameters);
   }

   /**
    * Get an image resource from the default plugin bundle, or return null if not found.
    */
   public static function getImage(key:String) : Class {
      return ResourceManager.getInstance().getClass(BUNDLE_NAME, key);
   }

   /**
    * Create a QuerySpec using a simple constraint to match all objects with a
    * certain type. Using this QuerySpec as-is in a DataRequest will return an array
    * of items with their corresponding property values.
    *
    * @param objectType
    *       Type of objects to retrieve.
    * @param properties
    *       The array of property names to retrieve.
    * @return
    *       The QuerySpec ready to be used.
    */
   public static function createSimpleConstraintQuerySpec(
         objectType:String, properties:Array):QuerySpec {
      var resourceSpec:ResourceSpec = new ResourceSpec();
      resourceSpec.constraint = new Constraint();
      resourceSpec.constraint.targetType = objectType;

      var propSpec:PropertySpec = new PropertySpec();
      propSpec.propertyNames = properties;
      resourceSpec.propertySpecs = [propSpec];

      var resultSpec:ResultSpec = new ResultSpec();
      resultSpec.maxResultCount = -1; // get everything by default
      resultSpec.offset = 0; // no paging

      var qs:QuerySpec = new QuerySpec();
      qs.resourceSpec = resourceSpec;
      qs.resultSpec = resultSpec;
      return qs;
   }

   /**
    * Creates a Constraint based on an object's property.
    *
    * @param objectType
    *       Type of object to retrieve.
    * @param propertyName
    *       Name of the property to be matched.
    * @param comparator
    *       The operator to use for comparison.
    *       ('equals', 'unequals', 'matches', 'ranges_between', etc.).
    * @param comparableValue
    *       The value to compare.
    *
    * @return The new PropertyConstraint.
    */
   public static function createPropertyConstraint(
         objectType:String,
         propertyName:String,
         comparator:Comparator,
         comparableValue:Object):PropertyConstraint {

      var constraint:PropertyConstraint = new PropertyConstraint();
      constraint.targetType = objectType;
      constraint.propertyName = propertyName;
      constraint.comparator = comparator;
      constraint.comparableValue = comparableValue;

      return constraint;
   }

}
}